<?php 
date_default_timezone_set('Asia/Jakarta');
session_start();

if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

require 'functions.php';

// HANDLE POST DATA dari fetch()
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["simpan"])) {
    $result = tambah_pelayanan($_POST);
    if ($result > 0) {
        echo "sukses";
    } else {
        echo "gagal";
    }
    exit;
}

$logkanwil = $_SESSION["logkanwil"];
$username = $_SESSION["username"];

// Ambil data pengguna dari master_layanan
$data_user = query("SELECT * FROM master_layanan WHERE nama = '$username' LIMIT 1");
$data = $data_user ? $data_user[0] : [
    "sekolah" => "", "kelas" => "", "tgl_lahir" => "", "alamat" => "", "wawa" => ""
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Data Pelayanan</title>
    <link rel="shortcut icon" href="idea.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: Arial, sans-serif; padding: 10px; }
        h1 { font-size: 20px; text-align: center; }
        form {
            max-width: 400px; margin: auto; background: #f9f9f9;
            padding: 15px; border-radius: 8px; box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }
        table { width: 100%; }
        td { padding: 6px; vertical-align: middle; }
        input[type="text"], input[type="date"], input[type="number"] {
            width: 100%; padding: 6px; font-size: 14px;
        }
        button { width: 100%; padding: 10px; font-size: 14px; }
        @media screen and (max-width: 380px) {
            h1 { font-size: 18px; }
            input[type="text"], button { font-size: 12px; padding: 6px; }
        }
    </style>
</head>
<body>

<div class="mb-2 text-center">
    <span>USER: <?= htmlspecialchars($logkanwil) ?></span><br>
    <a href="logout.php">Logout</a> | 
    <a href="index.php">Home</a>
</div>

<h1>Tambah Data Pelayanan</h1>

<form id="formData" enctype="multipart/form-data">
    <table>
        <tr>
            <td><label>Nama:</label></td>
            <td>
                <input type="text" value="<?= htmlspecialchars($username); ?>" readonly class="form-control">
                <input type="hidden" name="nama" value="<?= htmlspecialchars($username); ?>">
            </td>
        </tr>
        <tr>
            <td><label>Sekolah:</label></td>
            <td><input type="text" name="sekolah" value="<?= htmlspecialchars($data['sekolah']); ?>" readonly class="form-control"></td>
        </tr>
        <tr>
            <td><label>Kelas:</label></td>
            <td><input type="text" name="kelas" value="<?= htmlspecialchars($data['kelas']); ?>" readonly class="form-control"></td>
        </tr>
        <tr>
            <td><label>Tgl Lahir:</label></td>
            <td><input type="text" name="tgl_lahir" value="<?= htmlspecialchars($data['tgl_lahir']); ?>" readonly class="form-control"></td>
        </tr>
        <tr>
            <td><label>Alamat:</label></td>
            <td><input type="text" name="alamat" value="<?= htmlspecialchars($data['alamat']); ?>" readonly class="form-control"></td>
        </tr>
        <tr>
            <td><label>Wawa:</label></td>
            <td><input type="text" name="wawa" value="<?= htmlspecialchars($data['wawa']); ?>" readonly class="form-control"></td>
        </tr>
        <tr>
            <td><label for="kelompok">Kelompok:</label></td>
            <td><input type="number" name="kelompok" id="kelompok" required min="1" max="9"></td>
        </tr>
        <tr>
            <td><label for="tgl_pelayanan">Tgl Pelayanan:</label></td>
            <td><input required type="date" name="tgl_pelayanan" id="tgl_pelayanan"></td>
        </tr>
        <tr>
            <td colspan="2">
                <button class="btn btn-danger" type="submit">Konfirmasi</button>
            </td>
        </tr>
    </table>
</form>

<script>
document.getElementById("formData").addEventListener("submit", function(e) {
    e.preventDefault();

    const nama = document.querySelector('input[name="nama"]').value;
    const sekolah = document.querySelector('input[name="sekolah"]').value;
    const kelas = document.querySelector('input[name="kelas"]').value;
    const tgl_lahir = document.querySelector('input[name="tgl_lahir"]').value;
    const alamat = document.querySelector('input[name="alamat"]').value;
    const wawa = document.querySelector('input[name="wawa"]').value;
    const kelompok = document.getElementById("kelompok").value;
    const tgl_pelayanan = document.getElementById("tgl_pelayanan").value;

    const konfirmasi = confirm(`Konfirmasi Data:
Nama: ${nama}
Sekolah: ${sekolah}
Kelas: ${kelas}
Tgl Lahir: ${tgl_lahir}
Alamat: ${alamat}
Wawa: ${wawa}
Kelompok: ${kelompok}
Tgl Pelayanan: ${tgl_pelayanan}

Lanjutkan?`);
    
    if (konfirmasi) {
        const form = new FormData();
        form.append("nama", nama);
        form.append("sekolah", sekolah);
        form.append("kelas", kelas);
        form.append("tgl_lahir", tgl_lahir);
        form.append("alamat", alamat);
        form.append("wawa", wawa);
        form.append("kelompok", kelompok);
        form.append("tgl_pelayanan", tgl_pelayanan);
        form.append("simpan", "1");

        fetch(window.location.href, {
            method: "POST",
            body: form
        })
        .then(res => res.text())
        .then(result => {
            if (result.trim() === "sukses") {
                alert("Data berhasil disimpan!");
                window.location.href = "index.php";
            } else {
                alert("Gagal menyimpan data: " + result);
            }
        })
        .catch(err => {
            alert("Terjadi kesalahan: " + err);
        });
    }
});
</script>

</body>
</html>
