<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Data</title>
    <link rel="shortcut icon" href="idea.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 10px;
        }
        h1 {
            font-size: 20px;
            text-align: center;
        }
        form {
            max-width: 400px;
            margin: auto;
            background: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
        }
        td {
            padding: 6px;
            vertical-align: middle;
        }
        input[type="text"], input[type="file"] {
            width: 100%;
            padding: 6px;
            font-size: 14px;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 14px;
        }
        .radio-group {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
        }
        @media screen and (max-width: 380px) {
            h1 {
                font-size: 18px;
            }
            input[type="text"], button {
                font-size: 12px;
                padding: 6px;
            }
            .radio-group {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>

<div class="mb-2 text-center">
    <span>USER: <?= $logkanwil ?></span>
    <br>
    <a href="house_hunter1.php">Home</a>
</div>

<h1>Tambah Data</h1>

<form id="formData" enctype="multipart/form-data">
    <table>
        <tr>
            <td><label for="nama">Nama:</label></td>
            <td><input type="text" name="nama" id="nama" required maxlength="20" onkeyup="this.value = this.value.toUpperCase()" autofocus></td>
        </tr>
        <tr>
            <td><label for="alamat">Alamat:</label></td>
            <td><input type="text" name="alamat" id="alamat" required maxlength="50" onkeyup="this.value = this.value.toUpperCase()"></td>
        </tr>
        <tr>
            <td>Gender:</td>
            <td class="radio-group">
                <label><input type="radio" name="jk" value="Pria" required> Pria</label>
                <label><input type="radio" name="jk" value="Wanita"> Wanita</label>
            </td>
        </tr>
        <tr>
            <td><label for="foto">Foto:</label></td>
            <td><input type="file" name="foto" id="foto" accept="image/png, image/jpeg" required></td>
        </tr>
        <tr>
            <td colspan="2">
                <button class="btn btn-danger" type="submit">Konfirmasi</button>
            </td>
        </tr>
    </table>
</form>

<script>
document.getElementById("formData").addEventListener("submit", function(e) {
    e.preventDefault();

    const nama = document.getElementById("nama").value.toUpperCase();
    const alamat = document.getElementById("alamat").value.toUpperCase();
    const jk = document.querySelector('input[name="jk"]:checked')?.value;
    const foto = document.getElementById("foto").files[0];

    if (!jk) {
        alert("Pilih jenis kelamin!");
        return;
    }

    if (!foto) {
        alert("Unggah foto terlebih dahulu!");
        return;
    }

    fetch("get_ramalan.php")
        .then(response => response.text())
        .then(ramalan => {
            const konfirmasi = confirm(`Konfirmasi Data:\nNama: ${nama}\nAlamat: ${alamat}\nRamalan AI: ${ramalan}\n\nLanjutkan?`);
            if (konfirmasi) {
                const suara = new Audio(`tts.php?text=Halo adik ${encodeURIComponent(nama)}, alamat ${encodeURIComponent(alamat)}, ${encodeURIComponent(ramalan)} apakah benar ?&lang=id`);
                suara.play().then(() => {
                    setTimeout(() => {
                        const form = new FormData();
                        form.append("nama", nama);
                        form.append("alamat", alamat);
                        form.append("jk", jk);
                        form.append("ramalan_ai", ramalan);
                        form.append("simpan", "1");
                        form.append("foto", foto);

                        fetch("house_hunter.php", {
                            method: "POST",
                            body: form
                        }).then(response => response.text())
                          .then(result => {
                            document.open();
                            document.write(result);
                            document.close();
                        });
                    }, 8000);
                });
            }
        });
});
</script>

<?php
if (isset($_POST["simpan"])) {
    $fotoName = "";
    if (isset($_FILES["foto"]) && $_FILES["foto"]["error"] === 0) {
        $ext = pathinfo($_FILES["foto"]["name"], PATHINFO_EXTENSION);
        $fotoName = uniqid() . '.' . $ext;
        $uploadPath = "uploads/" . $fotoName;

        $validExt = ['jpg', 'jpeg', 'png'];
        if (in_array(strtolower($ext), $validExt) && $_FILES["foto"]["size"] < 4500000) {
            move_uploaded_file($_FILES["foto"]["tmp_name"], $uploadPath);
            $_POST["foto"] = $fotoName;
        } else {
            echo "<script>alert('File foto tidak valid atau terlalu besar!'); window.location.href = 'house_hunter.php';</script>";
            exit;
        }
    } else {
        echo "<script>alert('Gagal mengunggah foto!'); window.location.href = 'house_hunter.php';</script>";
        exit;
    }

    // Simpan data ke tabel data_hh
    $conn = new mysqli("localhost", "u1665228", "niaga1234", "u1665228_student");
    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    $nama = strtoupper($conn->real_escape_string($_POST["nama"]));
    $alamat = strtoupper($conn->real_escape_string($_POST["alamat"]));
    $jk = $conn->real_escape_string($_POST["jk"]);
    $ramalan_ai = $conn->real_escape_string($_POST["ramalan_ai"]);
    $foto = $conn->real_escape_string($_POST["foto"]);

    $sql = "INSERT INTO data_hh (nama, alamat, jk, ramalan_ai, foto) 
            VALUES ('$nama', '$alamat', '$jk', '$ramalan_ai', '$foto')";

    if ($conn->query($sql) === TRUE) {
        echo "<script>
            alert('Data berhasil ditambahkan!');
            window.location.href = 'house_hunter1.php';
        </script>";
    } else {
        echo "<script>
            alert('Data gagal ditambahkan!');
            window.location.href = 'house_hunter.php';
        </script>";
    }

    $conn->close();
}
?>

</body>
</html>
