<?php
// Setting awal
date_default_timezone_set('Asia/Jakarta');
error_reporting(E_ALL);
require 'functions.php';

session_start();
if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

// Tangkap filter tanggal dari URL
$tanggalFilter = $_GET['tanggal'] ?? '';
$where = '';
if (!empty($tanggalFilter)) {
    $tanggalSQL = date("Y-m-d", strtotime(str_replace('/', '-', $tanggalFilter)));
    $where = "WHERE tgl_pelayanan = '$tanggalSQL'";
}

// Jika export, atur header Excel
if (isset($_GET['export'])) {
    header("Content-type: application/vnd-ms-excel");
    header("Content-Disposition: attachment; filename=data_pelayanan_" . date("d-m-Y_H-i-s") . ".xls");
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Data Pelayanan</title>
    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <!-- Flatpickr JS -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    <style>
        body { font-family: sans-serif; }
        table { border-collapse: collapse; margin: 20px auto; }
        th, td { border: 1px solid #3c3c3c; padding: 5px 10px; }
        a.button {
            background: blue;
            color: white;
            padding: 8px 12px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin: 10px;
        }
        form { text-align: center; margin-top: 10px; }
    </style>
</head>
<body>

<?php if (!isset($_GET['export'])): ?>
    <center><h1>Data Pelayanan</h1></center>

    <!-- Form Filter -->
    <form method="get">
        <label for="tanggal">Filter Tanggal Pelayanan:</label>
        <input type="text" id="tanggal" name="tanggal" value="<?= htmlspecialchars($tanggalFilter) ?>" autocomplete="off">
        <button type="submit">Cari</button>
    </form>

    <!-- Tombol Export -->
    <center>
        <a href="?export=1<?= !empty($tanggalFilter) ? '&tanggal=' . urlencode($tanggalFilter) : '' ?>" class="button">EXPORT KE EXCEL</a>
    </center>
<?php endif; ?>

<table>
    <thead>
        <tr>
            <th>No.</th>
            <th>Nama</th>
            <th>Kelas</th>
            <th>Alamat Tinggal</th>
            <th>Tgl Lahir</th>
            <th>Tgl Pelayanan</th>
            <th>Kelompok</th>
        </tr>
    </thead>
    <tbody>
        <?php
        // Query berdasarkan filter
        $data = mysqli_query($conn, "SELECT * FROM data_anggota $where ORDER BY tgl_pelayanan,kelompok,nama");
        $no = 1;
        while ($d = mysqli_fetch_array($data)) {
            echo "<tr>";
            echo "<td>" . $no++ . "</td>";
            echo "<td>" . htmlspecialchars($d['nama']) . "</td>";
            echo "<td>" . htmlspecialchars($d['kelas']) . "</td>";
            echo "<td>" . htmlspecialchars($d['alamat']) . "</td>";
  
   
            // Validasi tgl_lahir
            $tgl_lahir = $d['tgl_lahir'];
            echo "<td>" . (!empty($tgl_lahir) && $tgl_lahir != "0000-00-00" ? date("d-m-Y", strtotime($tgl_lahir)) : '-') . "</td>";

        
            // Tgl pelayanan
            $tgl_pelayanan = $d['tgl_pelayanan'];
            echo "<td>" . (!empty($tgl_pelayanan) && $tgl_pelayanan != "0000-00-00" ? date("d-m-Y", strtotime($tgl_pelayanan)) : '-') . "</td>";

            // Kelompok
            echo "<td>" . htmlspecialchars($d['kelompok']) . "</td>";
            echo "</tr>";
        }
        ?>
    </tbody>
</table>

<!-- Inisialisasi Flatpickr -->
<script>
    flatpickr("#tanggal", {
        dateFormat: "d-m-Y"
    });
</script>

</body>
</html>
