// esp32_iot.ino
#include <WiFi.h>
#include <WiFiClient.h>
#include <HTTPClient.h>

const char* ssid = "NAMA_WIFI";      // ganti
const char* password = "PASSWORD";   // ganti

WiFiServer server(5000); // server TCP untuk terima data dari Python

String phpServer = "http://yourserver.com/save_data.php"; // ganti domain/IP server

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("ESP32 Terhubung ke WiFi!");
  server.begin();
}

void loop() {
  WiFiClient client = server.available();
  if (client) {
    String data = client.readStringUntil('\n');
    data.trim();
    Serial.println("Diterima dari Python: " + data);

    int commaIndex = data.indexOf(',');
    if (commaIndex > 0) {
      String suhu = data.substring(0, commaIndex);
      String kelembapan = data.substring(commaIndex + 1);

      if (WiFi.status() == WL_CONNECTED) {
        HTTPClient http;
        http.begin(phpServer);
        http.addHeader("Content-Type", "application/x-www-form-urlencoded");

        String postData = "suhu=" + suhu + "&kelembapan=" + kelembapan;
        int httpResponseCode = http.POST(postData);

        if (httpResponseCode > 0) {
          Serial.println("Data terkirim ke server: " + String(httpResponseCode));
        } else {
          Serial.println("Error kirim: " + String(httpResponseCode));
        }
        http.end();
      }
    }
    client.stop();
  }
}
