<?php
session_start();
if(!isset($_SESSION['user'])) { header('Location: index.php'); exit; }
require 'db.php';
$user = $_SESSION['user'];
$schedule_id = $_REQUEST['schedule_id'] ?? null;

if($_SERVER['REQUEST_METHOD']==='POST') {
    $schedule_id = intval($_POST['schedule_id']);
    $original_id = intval($_POST['original_id']);
    $substitute_id = intval($_POST['substitute_id']);
    $reason = $_POST['reason'] ?? '';
    $created_by = $user['id'];
    $stmt = $pdo->prepare('INSERT INTO substitutions (schedule_id, original_user_id, substitute_user_id, created_by, reason) VALUES (?,?,?,?,?)');
    $stmt->execute([$schedule_id, $original_id, $substitute_id, $created_by, $reason]);
    header('Location: dashboard.php');
    exit;
}

$stmt = $pdo->prepare('SELECT s.*, g.name as group_name FROM schedule s LEFT JOIN groups_tbl g ON s.group_id=g.id WHERE s.id = ? LIMIT 1');
$stmt->execute([$schedule_id]);
$s = $stmt->fetch();

$members = [];
if($s && $s['group_id']) {
    $stmtm = $pdo->prepare('SELECT * FROM users WHERE group_id = ?');
    $stmtm->execute([$s['group_id']]);
    $members = $stmtm->fetchAll();
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>Pengajuan Pengganti</title></head><body>
<p><a href="dashboard.php">Back</a></p>
<?php if(!$s) { echo '<p>Jadwal tidak ditemukan.</p>'; exit; } ?>
<h3>Ajukan Pengganti untuk <?php echo htmlspecialchars($s['ms_date'].' '.$s['ms_time'].' - '.$s['group_name']); ?></h3>
<form method="post">
  <input type="hidden" name="schedule_id" value="<?php echo htmlspecialchars($s['id']); ?>">
  Original (yang berhalangan):<br>
  <select name="original_id" required>
    <?php foreach($members as $m): ?>
      <option value="<?php echo $m['id']; ?>"><?php echo htmlspecialchars($m['name'].' ('.$m['email'].')'); ?></option>
    <?php endforeach; ?>
  </select><br><br>
  Pengganti:<br>
  <select name="substitute_id" required>
    <?php foreach($members as $m): ?>
      <option value="<?php echo $m['id']; ?>"><?php echo htmlspecialchars($m['name'].' ('.$m['email'].')'); ?></option>
    <?php endforeach; ?>
  </select><br><br>
  Alasan:<br>
  <input type="text" name="reason"><br><br>
  <button type="submit">Ajukan</button>
</form>
</body></html>
