<?php
// send_reminders.php
// Run this by cron every 10-60 minutes. It finds reminders with remind_at <= now and not sent.
// This script uses PHP mail() — configure server / use SMTP wrapper in production.

require 'db.php';

$stmt = $pdo->prepare('SELECT r.*, s.ms_date, s.ms_time, u.email, u.name FROM reminders r JOIN schedule s ON s.id=r.schedule_id JOIN users u ON u.id=r.user_id WHERE r.sent = 0 AND r.remind_at <= NOW()');
$stmt->execute();
$rows = $stmt->fetchAll();

foreach($rows as $r) {
    $to = $r['email'];
    $subject = 'Pengingat Misa ' . $r['ms_date'] . ' ' . substr($r['ms_time'],0,5);
    $message = "Halo " . $r['name'] . ",\n\nIni pengingat bahwa Anda dijadwalkan pada misa tanggal " . $r['ms_date'] . " pukul " . substr($r['ms_time'],0,5) . ".\n\nSalam.";
    $headers = 'From: noreply@' . ($_SERVER['HTTP_HOST'] ?? 'paroki.local') . "\r\n";
    if(@mail($to, $subject, $message, $headers)) {
        $u = $pdo->prepare('UPDATE reminders SET sent=1 WHERE id=?');
        $u->execute([$r['id']]);
    }
}
echo "Done. Checked: " . count($rows) . " reminders.\n";
?>
