<?php
session_start();
if(!isset($_SESSION['user'])) { header('Location: index.php'); exit; }
require 'db.php';
$stmt = $pdo->prepare('SELECT s.*, g.name as group_name FROM schedule s LEFT JOIN groups_tbl g ON s.group_id=g.id WHERE s.ms_date >= CURDATE() ORDER BY s.ms_date, s.ms_time');
$stmt->execute();
$schedules = $stmt->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Jadwal</title></head><body>
<h2>Semua Jadwal</h2>
<p><a href="dashboard.php">Back</a></p>
<table border="1" cellpadding="6">
<tr><th>Tanggal</th><th>Waktu</th><th>Kelompok</th><th>Note</th></tr>
<?php foreach($schedules as $s): ?>
<tr>
<td><?php echo htmlspecialchars($s['ms_date']); ?></td>
<td><?php echo htmlspecialchars(substr($s['ms_time'],0,5)); ?></td>
<td><?php echo htmlspecialchars($s['group_name']); ?></td>
<td><?php echo htmlspecialchars($s['note']); ?></td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
