-- Create database (if not exists) and tables
CREATE DATABASE IF NOT EXISTS `misa_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `misa_db`;

-- users: members and admins
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  email VARCHAR(150) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('member','admin') NOT NULL DEFAULT 'member',
  group_id INT DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- groups
CREATE TABLE IF NOT EXISTS groups_tbl (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL
) ENGINE=InnoDB;

-- schedule: weekly schedule entries (date, time, group assigned)
CREATE TABLE IF NOT EXISTS schedule (
  id INT AUTO_INCREMENT PRIMARY KEY,
  ms_date DATE NOT NULL,
  ms_time TIME NOT NULL,
  group_id INT DEFAULT NULL,
  note VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- substitutions: temporary member changes (who's replaced and by whom) and reason
CREATE TABLE IF NOT EXISTS substitutions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  schedule_id INT NOT NULL,
  original_user_id INT NOT NULL,
  substitute_user_id INT NOT NULL,
  created_by INT NOT NULL,
  reason VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- reminders: records of reminders set (could be used to avoid duplicates)
CREATE TABLE IF NOT EXISTS reminders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  schedule_id INT NOT NULL,
  user_id INT NOT NULL,
  remind_at DATETIME NOT NULL,
  sent TINYINT(1) DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- Seed groups (based on your uploaded PDF groups)
INSERT INTO groups_tbl (name) VALUES
('Kelompok 1'),('Kelompok 2'),('Kelompok 3'),('Kelompok 4'),('Kelompok 5'),
('Kelompok 6'),('Kelompok 7'),('Kelompok 8'),('Kelompok 9');

-- IMPORTANT: create an admin user. Replace the password hash below with PHP's password_hash output.
-- Example to generate hash in PHP: <?php echo password_hash('admin123', PASSWORD_DEFAULT); ?>
INSERT INTO users (name, email, password, role, group_id) VALUES
('Admin', 'admin@paroki.local', '$2y$10$replace_with_php_password_hash', 'admin', NULL);

-- Example schedule rows (adjust dates as needed)
INSERT INTO schedule (ms_date, ms_time, group_id, note) VALUES
(DATE_ADD(CURDATE(), INTERVAL 1 DAY), '17:00:00', 1, 'Sabtu Pk.17.00'),
(DATE_ADD(CURDATE(), INTERVAL 2 DAY), '07:30:00', 2, 'Minggu Pk.07.30'),
(DATE_ADD(CURDATE(), INTERVAL 2 DAY), '10:00:00', 3, 'Minggu Pk.10.00');
