<?php
session_start();
if(!isset($_SESSION['user'])) { header('Location: index.php'); exit; }
require 'db.php';
$user = $_SESSION['user'];

// Fetch upcoming schedule (next 30 days)
$stmt = $pdo->prepare('SELECT s.*, g.name as group_name FROM schedule s LEFT JOIN groups_tbl g ON s.group_id=g.id WHERE s.ms_date >= CURDATE() ORDER BY s.ms_date, s.ms_time LIMIT 100');
$stmt->execute();
$schedules = $stmt->fetchAll();

// Fetch substitutions for user (if any)
$stmt2 = $pdo->prepare('SELECT sub.*, u.name as original_name, us.name as substitute_name, sch.ms_date, sch.ms_time FROM substitutions sub JOIN users u ON u.id=sub.original_user_id JOIN users us ON us.id=sub.substitute_user_id JOIN schedule sch ON sch.id=sub.schedule_id WHERE u.id = ? OR us.id = ? LIMIT 50');
$stmt2->execute([$user['id'],$user['id']]);
$subs = $stmt2->fetchAll();

?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Dashboard - Misa Manager</title></head>
<body>
<h2>Halo, <?php echo htmlspecialchars($user['name']); ?> (<?php echo htmlspecialchars($user['role']); ?>)</h2>
<p><a href="schedule.php">Lihat Jadwal</a> | <?php if($user['role']=='admin') echo '<a href="admin.php">Admin Panel</a> |'; ?> <a href="logout.php">Logout</a></p>

<h3>Upcoming Schedule (next dates)</h3>
<table border="1" cellpadding="6">
<tr><th>Tanggal</th><th>Waktu</th><th>Kelompok</th><th>Note</th><th>Aksi</th></tr>
<?php foreach($schedules as $s): ?>
  <tr>
    <td><?php echo htmlspecialchars($s['ms_date']); ?></td>
    <td><?php echo htmlspecialchars(substr($s['ms_time'],0,5)); ?></td>
    <td><?php echo htmlspecialchars($s['group_name']); ?></td>
    <td><?php echo htmlspecialchars($s['note']); ?></td>
    <td>
      <form method="post" action="set_reminder.php" style="display:inline">
        <input type="hidden" name="schedule_id" value="<?php echo $s['id']; ?>">
        <button type="submit">Set Reminder</button>
      </form>
      <form method="get" action="substitute.php" style="display:inline">
        <input type="hidden" name="schedule_id" value="<?php echo $s['id']; ?>">
        <button type="submit">Ajukan Pengganti</button>
      </form>
    </td>
  </tr>
<?php endforeach; ?>
</table>

<h3>Subs terkait anda</h3>
<?php if(count($subs)==0) echo '<p>Tidak ada penggantian terkait Anda.</p>'; ?>
<ul>
<?php foreach($subs as $ss): ?>
  <li><?php echo htmlspecialchars($ss['ms_date'].' '.$ss['ms_time'].': '.$ss['original_name'].' digantikan oleh '.$ss['substitute_name'].' (alasan: '.$ss['reason'].')'); ?></li>
<?php endforeach; ?>
</ul>

</body>
</html>
