<?php
session_start();
if(!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { header('Location: index.php'); exit; }
require 'db.php';

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['action'])) {
    if($_POST['action']==='add_schedule') {
        $ms_date = $_POST['ms_date'];
        $ms_time = $_POST['ms_time'];
        $group_id = $_POST['group_id']?:NULL;
        $note = $_POST['note']?:NULL;
        $stmt = $pdo->prepare('INSERT INTO schedule (ms_date, ms_time, group_id, note) VALUES (?,?,?,?)');
        $stmt->execute([$ms_date, $ms_time, $group_id, $note]);
    } elseif($_POST['action']==='add_user') {
        $name = $_POST['name'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $role = $_POST['role'];
        $group_id = $_POST['group_id']?:NULL;
        $stmt = $pdo->prepare('INSERT INTO users (name,email,password,role,group_id) VALUES (?,?,?,?,?)');
        $stmt->execute([$name,$email,$password,$role,$group_id]);
    }
    header('Location: admin.php');
    exit;
}

$groups = $pdo->query('SELECT * FROM groups_tbl')->fetchAll();
$schedules = $pdo->query('SELECT s.*, g.name as group_name FROM schedule s LEFT JOIN groups_tbl g ON s.group_id=g.id ORDER BY s.ms_date')->fetchAll();
$users = $pdo->query('SELECT * FROM users ORDER BY id DESC')->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Admin Panel</title></head><body>
<p><a href="dashboard.php">Back</a></p>
<h2>Admin Panel</h2>

<h3>Tambah Jadwal</h3>
<form method="post">
  <input type="hidden" name="action" value="add_schedule">
  Tanggal: <input type="date" name="ms_date" required>
  Waktu: <input type="time" name="ms_time" required>
  Kelompok: <select name="group_id"><option value="">--none--</option><?php foreach($groups as $g) echo '<option value="'.$g['id'].'">'.htmlspecialchars($g['name']).'</option>'; ?></select>
  Note: <input name="note">
  <button type="submit">Tambah</button>
</form>

<h3>Tambah User/Akun</h3>
<form method="post">
  <input type="hidden" name="action" value="add_user">
  Nama: <input name="name" required><br>
  Email: <input name="email" type="email" required><br>
  Password: <input name="password" required><br>
  Role: <select name="role"><option value="member">Member</option><option value="admin">Admin</option></select><br>
  Group: <select name="group_id"><option value="">--none--</option><?php foreach($groups as $g) echo '<option value="'.$g['id'].'">'.htmlspecialchars($g['name']).'</option>'; ?></select><br>
  <button type="submit">Tambah Akun</button>
</form>

<h3>Daftar Jadwal</h3>
<table border="1" cellpadding="6"><tr><th>Tanggal</th><th>Waktu</th><th>Kelompok</th><th>Note</th></tr>
<?php foreach($schedules as $s): ?>
<tr>
<td><?php echo htmlspecialchars($s['ms_date']); ?></td>
<td><?php echo htmlspecialchars(substr($s['ms_time'],0,5)); ?></td>
<td><?php echo htmlspecialchars($s['group_name']); ?></td>
<td><?php echo htmlspecialchars($s['note']); ?></td>
</tr>
<?php endforeach; ?>
</table>

<h3>Daftar Pengguna</h3>
<table border="1" cellpadding="6"><tr><th>ID</th><th>Nama</th><th>Email</th><th>Role</th><th>Group</th></tr>
<?php foreach($users as $u): ?>
<tr>
<td><?php echo $u['id']; ?></td>
<td><?php echo htmlspecialchars($u['name']); ?></td>
<td><?php echo htmlspecialchars($u['email']); ?></td>
<td><?php echo htmlspecialchars($u['role']); ?></td>
<td><?php echo htmlspecialchars($u['group_id']); ?></td>
</tr>
<?php endforeach; ?>
</table>

</body></html>
